#define DisableWatchdog()  	\
   SIM_PCE |= SIM_PCE_COP; \
   COP_CTRL &= ~COP_CTRL_CEN; \
   SIM_PCE &= ~SIM_PCE_COP
              
/*****************************************************************************
*                           Freescale Semiconductor                          *
*                   Brazilian Semiconductor Tecnology Center                 *
*                                                                            *
*  Project    : AW app note                                                  *
*  Version    : 0.1                                                          *
*  Date       : 27/Mar/2009                                                  *
*  Engineer   : Bruno Bastos                                                 *
*                                                                            *
* -------------------------------------------------------------------------- *
*  Description:                                                              *
*                                                                            *
*    AW App note												             * 
*                                                                            *
******************************************************************************/

/************************* Project Include Files *****************************/

#include "util.h"
#include "lib_sys.h"
#include "lib_sci.h"
#include "lib_utils.h"

extern void trim_rosc();

/****************************** Prototypes ***********************************/

void delay(void);
void atualiza_l1(int8_t cor, int8_t intensidade);
void atualiza_l2(int8_t cor, int8_t intensidade);
void PWM_Init(void);
void get_adc(int8_t canal);
void enablePERclk(void);
void enablePERturbo(void);
void iic_write(void);

/*********************** Constants and Variables *****************************/

int16_t i,j,k,tempo=60000;
int16_t intens=0, ffg;
int aux;
char buffer;





/****************************** Main Function ********************************/

void main()
{
	int8_t c,i=0, dado=66;
	char address=0;
	
    DisableWatchdog();
    //trim_rosc();
    enable_pll();
    
    enablePERclk();
    enablePERturbo();
    PWM_Init();
    
    // Configure gpio c1 as input, gpio c2 as output.
//	configure_A0A1_GPIO(); 
	   
    TERMIO_Init(4400l);//4800bps
    //TERMIO_Init(200000l);
    
    //Print("*** A.W. APPNOTE ****\r\n");

    // Enable IPL0 interrupts, intialize ISR counters
//    asm(moveu.w #IPL0,sr);
//    pwm_reload_cnt = 0;
    
 		
	


	SIM_GPSA    = SIM_GPSA|0x0080;
	SIM_GPSB0   = SIM_GPSB0|0x1800;

  I2C_FREQDIV  = 0b00100010;  // Configure baud rate to 107 KHz
  I2C_CR1 = 0b10000000;   // Enable IIC and IIC interrupt


    //Print("Digite alguma coisa:");
   
    
         //atualiza_l1('R','b');//Azul
         //atualiza_l1('G','r');//vermelho
         //atualiza_l1('B','g');//verde
         //PWM_CTRL |= PWM_CTRL_LDOK;
         
         
         //PWM_VAL3=100;//verde
         //PWM_VAL1=100;//azul
         //PWM_VAL0=100;//vermelho
         //PWM_CTRL |= PWM_CTRL_LDOK;
         
	GPIOE_PER = 0x00;
	GPIOE_DDR = 0x00;
     
	
  	  
	while(1){
    	
    	address=GPIOE_DR;
    		 	
    	dado= TERMIO_GetChar();
    	
    	if(dado=='@')
    	{
    		dado= TERMIO_GetChar();
    		if(dado==address)
    		{
	    	    dado= TERMIO_GetChar();
	    	    if(dado=='L')
	    	    {	    	    
		    	    dado= TERMIO_GetChar();
		    		PWM_VAL0=dado;//vermelho
		    		
		    	 	dado= TERMIO_GetChar();
		         	PWM_VAL3=dado;//verde
		         	
		         	dado= TERMIO_GetChar();
		         	PWM_VAL1=dado;//azul
	         
	         		dado= TERMIO_GetChar();
	         		PWM_CTRL |= PWM_CTRL_LDOK;
    			} // end dado = L
    		} // end dado = endereco
    	} // end dado = @
  
    
	}
	
}

// ####################### Functions Implementation ##########################

/*****************************************************************************
* Funcion Name  : InitPorts
* Parameters    : none
* Returns       : none
* Notes         : 
******************************************************************************/

void delay(void)
{
int16_t teste;
     for(i=0;i<500;i++)
    	{
    	for(j=0;j<10000;j++)
    		{
    		for(k=0;k<10000;k++)
    		{
    		teste=k;	
    		}
    		}		
    	}
	
}

/*****************************************************************************
* Funcion Name  : InitPorts
* Parameters    : none
* Returns       : none
* Notes         : 
******************************************************************************/

void atualiza_l1(int8_t cor, int8_t intensidade)
{
  //int intens;
  switch(intensidade){
    case '0': intens=0; Print("Ok 0\r\n"); break;
    case '1': intens=10; Print("Ok 1\r\n"); break;
    case '2': intens=20; Print("Ok 2\r\n"); break;
    case '3': intens=30; Print("Ok 3\r\n"); break;
    case '4': intens=40; Print("Ok 4\r\n"); break;
    case 'g': intens=210; Print("Ok 5\r\n"); break;//210 - 100% para verde
    case 'r': intens=128; Print("Ok 6\r\n"); break;//13 - 100% para vermelho
    case 'b': intens=190; Print("Ok 7\r\n"); break;//190 - 100% para azul
    case '8': intens=80; Print("Ok 8\r\n"); break; 
    case '9': intens=90; Print("Ok 9\r\n"); break;
    default: intens=-1;
  }
    if(intens!=-1){
      if(cor=='R'){PWM_VAL1=intens;Print("Ok R\r\n");} // pino9
      if(cor=='G'){PWM_VAL0=intens;Print("Ok G\r\n");} // pino11
      if(cor=='B'){PWM_VAL3=intens;Print("Ok B\r\n");} // pino 30 azul
        
    }
}

/*****************************************************************************
* Funcion Name  : InitPorts
* Parameters    : none
* Returns       : none
* Notes         : 
******************************************************************************/

void atualiza_l2(int8_t cor, int8_t intensidade)
{
  //int intens;
  switch(intensidade){
    case '0': intens=0; Print("Ok 0\r\n"); break;
    case '1': intens=10; Print("Ok 1\r\n"); break;
    case '2': intens=20; Print("Ok 2\r\n"); break;
    case '3': intens=30; Print("Ok 3\r\n"); break;
    case '4': intens=40; Print("Ok 4\r\n"); break;
    case '5': intens=50; Print("Ok 5\r\n"); break;
    case '6': intens=60; Print("Ok 6\r\n"); break;
    case '7': intens=70; Print("Ok 7\r\n"); break;
    case '8': intens=80; Print("Ok 8\r\n"); break; 
    case '9': intens=90; Print("Ok 9\r\n"); break;
    default: intens=-1;
  }
    if(intens!=-1){
      if(cor=='R'){PWM_VAL2=intens;Print("Ok R\r\n");} // pino32
      if(cor=='G'){PWM_VAL5=intens;Print("Ok G\r\n");} // pino34
      if(cor=='B'){PWM_VAL4=intens;Print("Ok B\r\n");} // pino36 
        
    }
 
}

/*****************************************************************************
* Funcion Name  : InitPorts
* Parameters    : none
* Returns       : none
* Notes         : 
******************************************************************************/

// Os resistores shunt estao ligados nos canais ANA5,ANA7 e ANA9.
void get_adc(int8_t canal)
{
	
	if (canal ==5)
	{
		
	}
	if (canal ==7)
	{
		
	}

	if (canal ==9)
	{
		
	}
}


/*****************************************************************************
* Funcion Name  : InitPorts
* Parameters    : none
* Returns       : none
* Notes         : 
******************************************************************************/

/******************************************************************************
* pwm_ctrl(uint16_t mod, uint16_t v0, uint16_t v1, uint16_t v2)
*
* Enable PWM outputs in complimentary mode
******************************************************************************/
void pwm_ctrl(uint16_t mod, uint16_t v0, uint16_t v1, uint16_t v2)
{
    // Disable PWM
    PWM_CTRL &= ~PWM_CTRL_PWMEN;
    // Disable fault protection
    PWM_DMAP1 = 0;
    PWM_DMAP2 = 0;
    // Disable deadtime generators
    PWM_DTIM0 = 0;
    PWM_DTIM1 = 0;
    // Use complimentary mode
    PWM_CNFG &= ~(PWM_CNFG_INDEP01|PWM_CNFG_INDEP23|PWM_CNFG_INDEP45);
    // Set modulus (PWM period)
    PWM_CMOD = mod;
    // Set counter values (PWM duty cycle)
    PWM_VAL0 = v0;
    PWM_VAL1 = v0;
    PWM_VAL2 = v1;
    PWM_VAL3 = v1;
    PWM_VAL4 = v2;
    PWM_VAL5 = v2;
    // Enable PWM Outputs (set LDOK=1 before setting PWMEN=1)
    PWM_CTRL |= PWM_CTRL_LDOK;
    PWM_CTRL |= PWM_CTRL_PWMEN;    
    PWM_OUT = PWM_OUT_PAD_EN | PWM_OUT_OUT;
}

/*****************************************************************************
* Funcion Name  : InitPorts
* Parameters    : none
* Returns       : none
* Notes         : 
******************************************************************************/

void PWM_Init(void)
{
	int8_t i=0;
    
    
    ///////////////////////////////////////////////////////////////////////////
    // Use normal PWM output configuration
    //
    // PWM0 = GPIOA0
    // PWM1 = GPIOA1
    // PWM2 = GPIOA2
    // PWM3 = GPIOA3
    // PWM4 = GPIOA4
    // PWM5 = GPIOA5
    ///////////////////////////////////////////////////////////////////////////
    SIM_GPSA = 0;
    bitset(GPIOA_PER, BIT5+BIT4+BIT3+BIT2+BIT1+BIT0);
    
    ///////////////////////////////////////////////////////////////////////////
    // Test PWM channel swap with nBX = 0 and center aligned
    ///////////////////////////////////////////////////////////////////////////
  //  Print("CASE0: test PWM channel swap in independent mode with nBx = 0, center aligned\r\n");
    i = 1;
    pwm_reload_cnt = 0;

    PWM_CTRL &= ~(PWM_CTRL_PRSC);
    PWM_CTRL |= ((i-1) << 6);
  
    // Enable Reload Interrupts
    PWM_CTRL |= (PWM_CTRL_PWMRIE);

	// Enable Hardware Acceleration
	PWM_CCTRL |= PWM_CCTRL_ENHA;
	PWM_CCTRL &= ~(PWM_CCTRL_nBX);
	
	// Enable swap
	PWM_CCTRL |= (PWM_CCTRL_SWP45 | PWM_CCTRL_SWP23 | PWM_CCTRL_SWP01);
	
	// Disable edge aligned
	PWM_CNFG &= ~PWM_CNFG_EDG;
	PWM_CNFG |= (PWM_CNFG_INDEP01 | PWM_CNFG_INDEP23 | PWM_CNFG_INDEP45);

    // Set PWM frequency and duty cycle and enable PWM.
    //pwm_ctrl(100, 25, 50, 75);
    // Disable PWM
    PWM_CTRL &= ~PWM_CTRL_PWMEN;
    // Disable fault protection
    PWM_DMAP1 = 0;
    PWM_DMAP2 = 0;
    // Disable deadtime generators
    PWM_DTIM0 = 0;
    PWM_DTIM1 = 0;
    // Set modulus (PWM period)
    PWM_CMOD = 300;
    // Set counter values (PWM duty cycle)
    PWM_VAL0 = 0; // PA1 - pino11 - LED 2
    PWM_VAL1 = 0; // PA0 - pino9  - LED 1
    PWM_VAL2 = 0; // PA3 - pino32 - LED 4
    PWM_VAL3 = 0; // PA2 - pino30 - LED 3
    PWM_VAL4 = 0;// PA5 - pino36 - LED 6
    PWM_VAL5 = 0;// PA4 - pino34 - LED 5
    // Enable PWM Outputs (set LDOK=1 before setting PWMEN=1)
    PWM_CTRL |= PWM_CTRL_LDOK;
    PWM_CTRL |= PWM_CTRL_PWMEN;    
    PWM_OUT = PWM_OUT_PAD_EN | PWM_OUT_OUT;
	
}

/*****************************************************************************
* Funcion Name  : InitPorts
* Parameters    : none
* Returns       : none
* Notes         : 
******************************************************************************/

void enablePERclk(void)
{
    // Enable PWM Peripheral Clock
    SIM_PCE |= SIM_PCE_PWM;
    SIM_PCE |= SIM_PCE_I2C;
	
}

/*****************************************************************************
* Funcion Name  : InitPorts
* Parameters    : none
* Returns       : none
* Notes         : 
******************************************************************************/

void enablePERturbo(void)
{
    SIM_PCR |= SIM_PCR_SCI_CR;//Multiply SCI rate by 3
    SIM_PCR |= SIM_PCR_PWM_CR;//Multiply PWM rate by 3
	
}

/*****************************************************************************
* Funcion Name  : InitPorts
* Parameters    : none
* Returns       : none
* Notes         : 
******************************************************************************/

 void iic_write(void){
 	char temp;
 	char aux;
 	do {
  		I2C_CR1 = 0b10110000; // Enable MST and TX
  		I2C_DATA  = 0x02;      // Write on address 0x01 (7 MSBs)
  		for (temp=40; temp; temp--);
  		while(!I2C_SR_TCF);
  		if (I2C_SR_RXAK)
    	{
      		// Send STOP
      		I2C_CR1 = 0b10000000;
      		for (temp=5;temp;temp--);
    	}
    
  	} while (I2C_SR_RXAK); // Send address while ACK is not received
  
 	buffer = '@';
  	I2C_DATA = buffer;
  	while (!I2C_SR_TCF); // Wait the transfer end
  
  	buffer = 0xAB;
  	for(aux=0;aux<=5;aux++) {
    	I2C_DATA   = buffer;
    while (!I2C_SR_TCF); // Wait the transfer end
  	}
  
  	I2C_CR1 = 0b00000000; // Exit master mode, generatin STOP
  	while (!I2C_SR_TCF); // Wait the transfer end
}
